import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    popularProducts: [],
    loading: true,
};

export const getpopularProducts = createAsyncThunk(
    "items/getpopularProducts",
    async (URL) => {
        const data = await queryResponse(URL, "GET");
        return data;
    }
);

const popularProductsSlice = createSlice({
    name: "items",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getpopularProducts.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getpopularProducts.fulfilled, (state, { payload }) => {
            state.popularProducts = payload?.records?.data;
            state.loading = false;
        });
        builder.addCase(getpopularProducts.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default popularProductsSlice.reducer;
